<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include 'conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Verifica si la solicitud es de tipo POST y si se proporciona el ID de la consulta médica
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["idConsultaMedica"])) {
    // Obtén el ID de la consulta médica desde la solicitud POST
    $idConsultaMedica = $_POST["idConsultaMedica"];

    // Realiza la eliminación de la consulta médica en la base de datos
    $sql = "DELETE FROM historial_medico WHERE id_historial = $idConsultaMedica";
    $result = ejecutarConsulta($sql);

    // Verifica si la eliminación fue exitosa
    if ($result) {
        // Devuelve una respuesta de éxito en formato JSON
        echo json_encode(array('success' => true));
        exit();
    } else {
        // Si hubo un error en la eliminación, devuelve un mensaje de error en formato JSON
        echo json_encode(array('success' => false, 'message' => 'Error al eliminar la consulta médica.'));
        exit();
    }
} else {
    // Si no es una solicitud POST o no se proporciona el ID de la consulta médica, devuelve un mensaje de error en formato JSON
    echo json_encode(array('success' => false, 'message' => 'Solicitud no válida.'));
    exit();
}
?>
