<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: ../../pages/iniciar_sesion.php");
    exit();
}

include 'conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén el ID del cliente a eliminar
    $idCliente = $_POST["idCliente"];

    try {
        // Desactivar temporalmente la verificación de clave externa
        $sqlDesactivarFK = "SET FOREIGN_KEY_CHECKS=0";
        ejecutarConsulta($sqlDesactivarFK);

        // Ejemplo de eliminación en la base de datos
        $sqlEliminarCliente = "DELETE FROM clientes WHERE id_cliente = $idCliente";
        if (ejecutarConsulta($sqlEliminarCliente)) {
            // Devuelve una respuesta JSON indicando éxito
            echo json_encode(array("success" => true));
            exit();
        } else {
            // Devuelve una respuesta JSON indicando error
            echo json_encode(array("success" => false, "message" => "Error al eliminar el cliente"));
            exit();
        }
    } catch (Exception $e) {
        // Volver a activar la verificación de clave externa
        $sqlActivarFK = "SET FOREIGN_KEY_CHECKS=1";
        ejecutarConsulta($sqlActivarFK);

        // Lanzar excepción
        throw $e;
    }
}else {
    // Si no es una solicitud POST, redirige a la página de clientes
    header("Location: ../../pages/clientes.php");
    exit();
}
?>
