<?php

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}
include '../assets/includes/conexion.php';

// Mostrar mensajes de error
if (isset($_GET['error'])){
    $error = $_GET['error'];
    switch($error){
      case 'contrasena':
        $mensajeError = 'Las contraseñas no coinciden.';
        break;
      case 'existente':
        $mensajeError = 'Ya existe un usuario con la misma cedula o correo.';
        break;
      case 'registro':
        $mensajeError = 'Error al registrar el usuario.';
        break;
    }
}


$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();
// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener la lista de usuarios
function obtenerRoles()
{
    $sql = "SELECT * FROM roles";
    return ejecutarConsulta($sql);
}


?>


<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dentox - Registrar Usuario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

</head>
<body>

  <main class="container">
    <section class="py-5">
      <div class="row justify-content-center">
        <div class="col-md-6">
          <div class="card">
            <div class="card-header d-flex align-items-center justify-content-between">
              <img src="../assets/images/Dentox.png" width="150" class="logo">
              <h2 class="ms-4">Registrar Usuario</h2>
            </div>
            
            <div class="card-body">
              <!-- Mostrar mensaje de error -->
        <?php if (isset($mensajeError)) : ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $mensajeError; ?>
            </div>
        <?php endif; ?>
              <form action="../assets/includes/procesar_registro.php" method="post" enctype="multipart/form-data">
                <div class="mb-3">
                  <label for="username">Usuario</label>
                  <input type="text" class="form-control" id="username" name="username" placeholder="Introduce tu nombre de usuario o username" required>
                </div>
                <div class="mb-3">
                  <label for="nombre">Nombre</label>
                  <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Introduce tu nombre" required>
                </div>
                <div class="mb-3">
                  <label for="apellido">Apellido</label>
                  <input type="text" class="form-control" id="apellido" name="apellido" placeholder="Introduce tu apellido" required>
                </div>
                <div class="mb-3">
                  <label for="email">Correo electrónico</label>
                  <input type="email" class="form-control" id="email" name="email" placeholder="Introduce tu correo electrónico" required>
                </div>
                <div class="mb-3">
                  <label for="rol">Rol desempeñado:</label>
                  <select class="form-select" id="rol" name="rol" required>
                    <option value="" selected disabled>Seleccione el rol...</option>
                    <?php
                    // Obtener la lista de roles desde la base de datos
                    $roles = obtenerRoles();

                    // Verificar si hay roles
                    if ($roles->num_rows > 0) {
                      while ($rol = $roles->fetch_assoc()) {
                        echo "<option value='{$rol['id_rol']}'>{$rol['nombre_rol']}</option>";
                      }
                    }
                    ?>
                  </select>
                </div>
                <div class="mb-3">
                  <label for="cedula">Nro de Cédula:</label>
                  <input type="text" class="form-control" id="cedula" name="cedula" placeholder="Introduce el número de documento" required>
                </div>
                <div class="mb-3">
                  <label for="telefono">Teléfono:</label>
                  <input type="text" class="form-control" id="telefono" name="telefono" placeholder="Introduce el número de teléfono" required>
                </div>
                <div class="mb-3">
                  <label for="direccion">Dirección:</label>
                  <input type="text" class="form-control" id="direccion" name="direccion" placeholder="Introduce su dirección" required>
                </div>
                <div class="mb-3">
                  <label for="imagen">Imagen de Perfil:</label>
                  <input type="file" class="form-control" id="imagen" name="imagen" accept="image/*">
                </div>
                <div class="mb-3">
                  <label for="password">Contraseña</label>
                  <input type="password" class="form-control" id="password" name="password" placeholder="Introduce tu contraseña" required>
                </div>
                <div class="mb-3">
                  <label for="confirmPassword">Confirmar contraseña</label>
                  <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" placeholder="Confirma tu contraseña" required>
                </div>
                <!-- Puedes agregar más campos según la estructura de tu base de datos -->

                <div class="d-flex justify-content-between">
                    
                    <a href="usuarios.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                    <button type="submit" class="btn btn-primary">Registrar</button>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  </main>
  <?php include '../assets/includes/navegacion.php'; ?>
  <footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
  </footer>


</body>
</html>
