<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

$sqlClientes = "SELECT id_cliente, nombre FROM clientes";
$resultadoClientes = $conn->query($sqlClientes);

$sqlUsuarios = "SELECT id_usuario, nombre_usuario FROM usuarios";
$resultadoUsuarios = $conn->query($sqlUsuarios);

// Obtén el ID del estado "Pendiente" desde la tabla de estados_agendamientos
$sqlEstadoPendiente = "SELECT id_estado FROM estados_agendamientos WHERE nombre_estado = 'Pendiente'";

$resultadoEstadoPendiente = $conn->query($sqlEstadoPendiente);
$estadoPendiente = $resultadoEstadoPendiente->fetch_assoc();
$idEstadoPendiente = $estadoPendiente['id_estado'];

// Procesar el formulario cuando se envía
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $idCliente = $_POST["idCliente"];
    $idUsuario = $_POST["idUsuario"];
    $fechaCita = $_POST["fechaCita"];
    $horaCita = $_POST["horaCita"];
    $nota = $_POST["nota"];

    // Inserta el nuevo agendamiento en la base de datos
    $sqlInsert = "INSERT INTO agendamientos (id_cliente, id_usuario, fecha_cita, hora_cita, nota, id_estado)
                  VALUES (?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sqlInsert);
    $stmt->bind_param("iisssi", $idCliente, $idUsuario, $fechaCita, $horaCita, $nota, $idEstadoPendiente);
    $stmt->execute();
    
    // Verifica si la inserción fue exitosa
    if ($stmt->affected_rows > 0) {
        echo "<script>alert('Agendamiento registrado correctamente');</script>";
        header("Location: dashboard.php");
        exit();
    } else {
        echo "<script>alert('Error al registrar el agendamiento');</script>";
        header("Location: registrar_agenda.php");
        exit();
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Agendamientos</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha384-dTveEnQIJCpMSIP3C4PSLdJveBU8lqF1ehmhtZ3Iu2vU9kQpZzlhPmWQihJfVw49" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registrar Recordatorios</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <div class="mb-3">
                                    <label for="fechaCita">Fecha</label>
                                    <input type="date" class="form-control" id="fechaCita" name="fechaCita" required>
                                </div>
                                <div class="mb-3">
                                    <label for="horaCita">Hora</label>
                                    <input type="time" class="form-control" id="horaCita" name="horaCita" required>
                                </div>
                                <div class="mb-3">
                                    <label for="nota">Nota</label>
                                    <textarea class="form-control" id="nota" name="nota"></textarea>
                                </div>
                                <div class="">
                                    <a href="dashboard.php"><button type="button" class="btn btn-secondary">Volver</button></a>

                                    <button type="submit" class="btn btn-primary">Registrar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

        <!-- Agrega el script para buscar clientes -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2Xof8+cu6Qr5I5Ih0k5r4aFslw8Z5Gz0D93Q" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function () {
            
        });
    </script>
</body>
</html>
