<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Incluir las clases de PHPMailer, la conexión a la base de datos y otras configuraciones
require '../assets/PHPMailer-master/src/Exception.php';
require '../assets/PHPMailer-master/src/PHPMailer.php';
require '../assets/PHPMailer-master/src/SMTP.php';
require '../assets/includes/conexion.php';

$mail = new PHPMailer(true);

// Configuración del servidor de correo
$mail->isSMTP();
$mail->Host = 'dentox.com.py';
$mail->SMTPAuth = true;
$mail->Username = 'sistema@dentox.com.py';
$mail->Password = '$istema$12345';
$mail->SMTPSecure = 'tls';
$mail->Port = 587;

// Obtener la conexión a la base de datos
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Verificar la conexión a la base de datos
if (!$conn) {
    die("Error al conectar a la base de datos: " . mysqli_connect_error());
}

// Obtener la fecha actual
$fecha_actual = date('Y-m-d');

// Obtener todas las citas para el día actual
$query = "SELECT * FROM agendamientos WHERE fecha_cita = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "s", $fecha_actual);
mysqli_stmt_execute($stmt);
$resultado = mysqli_stmt_get_result($stmt);

while ($fila = mysqli_fetch_assoc($resultado)) {
    $id_cliente = $fila['id_cliente'];

    // Obtener información del cliente
    $query_cliente = "SELECT * FROM clientes WHERE id_cliente = ?";
    $stmt_cliente = mysqli_prepare($conn, $query_cliente);
    mysqli_stmt_bind_param($stmt_cliente, "i", $id_cliente);
    mysqli_stmt_execute($stmt_cliente);
    $resultado_cliente = mysqli_stmt_get_result($stmt_cliente);
    $cliente = mysqli_fetch_assoc($resultado_cliente);
    mysqli_stmt_close($stmt_cliente);

    // Configuración del destinatario y cuerpo del correo
    $destinatario = $cliente['contacto_email'];
    $nombre_cliente = $cliente['nombre'];
    $apellido_cliente = $cliente['apellido'];
    $asunto = 'Recordatorio de Cita';
    $cuerpo = "Hola $nombre_cliente $apellido_cliente,\n\nEste es un recordatorio de tu cita programada para hoy.\n\nFecha: {$fila['fecha_cita']}\nHora: {$fila['hora_cita']}\nNota: {$fila['nota']}\n\n¡Gracias!";
    
    // Configuración de PHPMailer
    $mail->setFrom('sistema@dentox.com.py', 'Dentox - Sistema');
    $mail->addAddress($destinatario, "$nombre_cliente $apellido_cliente");
    $mail->CharSet = 'UTF-8';
    $mail->Subject = $asunto;
    $mail->Body = $cuerpo;

    // Enviar el correo
    if (!$mail->send()) {
        // Puedes registrar el error en un archivo de registro o en la base de datos.
        echo 'Error al enviar el correo: ' . $mail->ErrorInfo;
    } else {
        echo "Correo enviado a $destinatario\n";
    }
}

// Cierre de la conexión a la base de datos
$conexionDB->desconectar();
?>
