<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Mostrar mensajes de error o éxito
$mensajeError = '';
$mensajeExito = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $numeroOrden = $_POST["numeroOrden"];

    // Buscar detalles de la orden de estudio
    $sqlDetalleOrden = "SELECT oe.id_orden_estudio, oe.id_cliente, oe.id_usuario, oe.fecha, oe.observacion, 
                                c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula AS cedula_paciente, c.fecha_nacimiento AS fecha_nacimiento, 
                                u.nombre AS nombre_medico, u.apellido AS apellido_medico, oo.id_orden_estudio as id_orden_ordenes, oo.id_estudio as id_estudio_ordenes,
                                e.nombre_estudio as nombre_estudio, e.precio as precio_estudio
                        FROM ordenes_estudios oe
                        JOIN ordenes_estudios_estudios oo ON oe.id_orden_estudio = oo.id_orden_estudio
                        JOIN estudios_medicos e ON oo.id_estudio = e.id_estudio
                        JOIN clientes c ON oe.id_cliente = c.id_cliente
                        JOIN usuarios u ON oe.id_usuario = u.id_usuario
                        WHERE oe.id_orden_estudio = ?";
    $stmtDetalleOrden = $conn->prepare($sqlDetalleOrden);
    $stmtDetalleOrden->bind_param("i", $numeroOrden);
    $stmtDetalleOrden->execute();
    $resultDetalleOrden = $stmtDetalleOrden->get_result();

    // Verificar si la orden de estudio existe
    if ($resultDetalleOrden->num_rows > 0) {
        $detalleOrden = $resultDetalleOrden->fetch_assoc();

        // Verificar si ya existen resultados médicos
        $sqlResultadosCargados = "SELECT id_resultado, id_orden_estudio, nombre_archivo, tipo_archivo FROM resultados_medicos WHERE id_orden_estudio = ?";
        $stmtResultadosCargados = $conn->prepare($sqlResultadosCargados);
        $stmtResultadosCargados->bind_param("i", $detalleOrden['id_orden_estudio']);
        $stmtResultadosCargados->execute();
        $resultCargados = $stmtResultadosCargados->get_result();

        $archivosCargados = array();

        if ($resultCargados->num_rows > 0) {
            while ($rowCargados = $resultCargados->fetch_assoc()) {
                $archivosCargados[] = $rowCargados;
            }
        }
        
        $resultadosInfo = array(
            'resultadosCargados' => count($archivosCargados),
            'archivosCargados' => $archivosCargados,
            'archivosPermitidos' => 10 - count($archivosCargados)
        );

        echo json_encode($resultadosInfo);
        exit();
    } else {
        // Orden de estudio no encontrada
        $mensajeError = 'La orden de estudio no fue encontrada.';
    }

    $stmtDetalleOrden->close();
    $stmtResultadosCargados->close();
}

// Mostrar mensajes de error o éxito
if ($mensajeError) {
    echo '<p style="color: red;">' . $mensajeError . '</p>';
}
if ($mensajeExito) {
    echo '<p style="color: green;">' . $mensajeExito . '</p>';
}
?>
