<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtén la lista de clientes para el selector de filtro
$sqlPacientes = "SELECT id_cliente, nombre, apellido FROM clientes";
$resultadoPacientes = ejecutarConsulta($sqlPacientes);


$rutaImagen = '../assets/images/Dentox.png';
$contenidoImagen = file_get_contents($rutaImagen);
$imagenBase64 = base64_encode($contenidoImagen);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Facturas de Ventas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.1/css/buttons.dataTables.min.css">

    <style>
        .dt-buttons.btn-group {
            margin-top: 10px;
        }

        .total-importe-cell {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }
    </style>
</head>


<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Facturas de Ventas</h2>
                            <a href="agregar_factura_venta.php">
                                <button type="button" class="btn btn-primary">
                                    Registrar Factura
                                </button>
                            </a>
                        </div>
                        <div class="card-body">
                            <!-- Selector de filtro por fecha -->
                            <label for="filtroFecha">Filtrar por Fecha:</label>
                            <input type="date" id="filtroFecha" name="filtroFecha">

                            <!-- Selector de filtro por proveedor -->
                            <label for="filtroPaciente">Filtrar por Paciente:</label>
                            <select id="filtroPaciente" name="filtroPaciente">
                                <option value="">Todos</option>
                                <?php while ($pacientes = $resultadoPacientes->fetch_assoc()) : ?>
                                    <option value="<?php echo $pacientes['id_cliente']; ?>"><?php echo $pacientes['nombre'] .' '. $pacientes['apellido']; ?></option>
                                <?php endwhile; ?>
                            </select>
                            <br><br>
                            <!-- Tabla de facturas de compras -->
                            <table id="tablaFacturasVentas" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th hidden>ID Factura</th>
                                        <th hidden>ID Paciente</th>
                                        <th hidden>Fecha-orig</th>
                                        <th>Fecha</th>
                                        <th>Tipo</th>
                                        <th>Paciente</th>
                                        <th>Teléfono</th>
                                        <th>Número de Factura</th>
                                        <th hidden>Importe Total</th>
                                        <th>Importe Total</th>
                                        <th>Tipo de Pago</th>
                                        <th>Estudio(s)</th>
                                        <th>Usuario</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Aquí se cargarán los registros de facturas de compras -->
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="4"></th>
                                        <th class="text-right">SubTotal:</th>
                                        <th class="total-importe-cell"></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>

                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Incluye las bibliotecas de DataTables, Buttons y jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

<!-- Configuración del DataTable -->
<script>
    $(document).ready(function () {

        sumarImportes();
        var dataTable;

        $.ajax({
            url: 'obtener_facturas_ventas.php',
            dataType: 'json',
            success: function (data) {
                var tableRows = '';

                $.each(data, function (index, row) {
                    const fechaPartes = row.fecha.split('-');
                    const fechaFormateada = fechaPartes[2] + '-' + fechaPartes[1] + '-' + fechaPartes[0];
                    tableRows += '<tr>' +
                        '<td hidden>' + row.id_factura + '</td>' +
                        '<td hidden>' + row.id_cliente + '</td>' +
                        '<td hidden>' + row.fecha + '</td>' +
                        '<td>' + fechaFormateada + '</td>' +
                        '<td>' + row.tipoFactura + '</td>' +
                        '<td>' + row.nombre_paciente + ' ' + row.apellido_paciente + ' - ' +  '(' + row.cedula_paciente + ')' + '</td>' +
                        '<td>' +  row.telefono_paciente + '</td>' +
                        '<td>' + row.numero_factura + '</td>' +
                        '<td hidden>' + row.importe_total + '</td>' +
                        '<td style="text-align:right;">' + parseFloat(row.importe_total).toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }) + '</td>' +
                        '<td>' + row.tipoPago + '</td>' +
                        '<td>' + row.nombres_estudios + '</td>' +
                        '<td>' + row.nombre_usuario + '</td>' +
                        '<td><a href="detalle_factura_venta.php?id=' + row.id_factura + '"><i class="fa fa-eye"></i></a>' +
                        
                                '<a href="#" class="btn-eliminar_factura" data-id="' + row.id_factura + '" title="Eliminar Factura">' +
                                '<i class="fa fa-trash"></i>' +
                                '</a>' +
                        '</td>' +
                        '</tr>';
                });

                $('#tablaFacturasVentas tbody').html(tableRows);
                sumarImportes();

                dataTable = $('#tablaFacturasVentas').DataTable({
                    "language": {
                        "url": "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json"
                    },
                    "dom": 'Bfrtip',
                    "buttons": [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ],
                    "order": [[1, 'desc']],
                    "columnDefs": [
                        {
                            "targets": [8],
                            "className": 'total-importe-cell'
                        }
                    ],

                });
            },
            error: function (error) {
                console.log(error);
            }
        });

        // suma los importes totales de la tabla, y actualiza el footer y la columna total-importe-cell

        function sumarImportes() {
            var total = 0;

            $('#tablaFacturasVentas tbody tr').each(function () {
                total += parseFloat($(this).find('td:eq(9)').text().replace(/\./g, '').replace(/\,/g, '.'));
            });

            $('.total-importe-cell').text(total.toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }));

            // Actualiza el valor de la variable total
            total = total.toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 });

            console.log(total);
        }




        $('#filtroFecha').on('change', function () {
            const filtroFecha = $(this).val();

            if (filtroFecha === '') {
                dataTable.destroy();
                return;
            }

            $('#tablaFacturasVentas').DataTable().column(2).search(filtroFecha).draw();
            sumarImportes();
        });

        $('#filtroPaciente').on('change', function () {
            const filtroPaciente = $(this).val();

            if (filtroPaciente === 'Todos') {
                dataTable.destroy();
                return;
            }

            $('#tablaFacturasVentas').DataTable().column(1).search(filtroPaciente).draw();

            sumarImportes();
        });

        $(document).on('click', '.btn-eliminar_factura', function () {
            if (confirm('¿Estás seguro de eliminar esta factura?')) {
                const idFactura = $(this).data('id');

                $.ajax({
                    url: 'eliminar_factura_venta.php',
                    method: 'POST',
                    data: {
                        idFactura: idFactura
                    },
                    success: function (response) {
                        const data = JSON.parse(response);

                        if (data.success) {
                            alert('Factura eliminada correctamente');
                            location.reload();
                        } else {
                            alert('Error al eliminar la factura');
                        }
                    },
                    error: function (error) {
                        console.log(error);
                    }
                });
            }
        });
    });
</script>


</body>
</html>
