<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtén la lista de proveedores para el selector de filtro
$sqlProveedores = "SELECT id_proveedor, nombre_empresa FROM proveedores";
$resultadoProveedores = ejecutarConsulta($sqlProveedores);

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Facturas de Compras</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.1/css/buttons.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Facturas de Compras</h2>
                            <a href="agregar_factura_compra.php">
                                <button type="button" class="btn btn-primary">
                                    Registrar Factura
                                </button>
                            </a>
                        </div>
                        <div class="card-body">
                            <!-- Selector de filtro por fecha -->
                            <label for="filtroFecha">Filtrar por Fecha:</label>
                            <input type="date" id="filtroFecha" name="filtroFecha">


                            <!-- Selector de filtro por proveedor -->
                            <label for="filtroProveedor">Filtrar por Proveedor:</label>
                            <select id="filtroProveedor" name="filtroProveedor">
                                <option value="">Todos</option>
                                <?php while ($proveedor = $resultadoProveedores->fetch_assoc()) : ?>
                                    <option value="<?php echo $proveedor['id_proveedor']; ?>"><?php echo $proveedor['nombre_empresa']; ?></option>
                                <?php endwhile; ?>
                            </select>
                            <br><br>
                            <!-- Tabla de facturas de compras -->
                            <table id="tablaFacturasCompras" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th hidden>ID Factura</th>
                                        <th hidden>ID Proveedor</th>
                                        <th>Proveedor</th>
                                        <th>RUC</th>
                                        <th hidden>Fecha-orig</th>
                                        <th>Fecha</th>
                                        <th>Número de Factura</th>
                                        <th>Importe Total</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Aquí se cargarán los registros de facturas de compras -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Incluye las bibliotecas de DataTables, Buttons y jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
    <!-- Configuración del DataTable -->
    <script>
        $(document).ready(function() {
            $.ajax({
                url: 'obtener_facturas_compras.php',
                dataType: 'json', // Especifica que la respuesta será en formato JSON
                success: function (data) {
                    // Construye dinámicamente las filas de la tabla con los datos JSON
                    var tableRows = '';
                    $.each(data, function (index, row) {
                        // Dividimos la fecha en partes
                        const fechaPartes = row.fecha.split('-');
                            
                            // Unimos las partes en el formato deseado
                            const fechaFormateada = fechaPartes[2] + '-' + fechaPartes[1] + '-' + fechaPartes[0]; 
        
                            // Formatear importe_total sin decimales y con separadores de miles
                            const importeTotalFormateado = parseFloat(row.importe_total).toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 });

                        
                            tableRows += '<tr>' +
                            '<td hidden>' + row.id_factura + '</td>' +
                            '<td hidden>' + row.id_proveedor + '</td>' +
                            '<td>' + row.nombre_empresa + '</td>' +
                            '<td>' + row.ruc + '</td>' +
                            '<td hidden>' + row.fecha + '</td>' +
                            '<td>' + fechaFormateada + '</td>' +
                            console.log(fechaFormateada) +
                            '<td>' + row.numero_factura + '</td>' +
                            '<td style="text-align:right;">' + importeTotalFormateado + '</td>' +
                            '<td><a href="detalle_factura_compra.php?id=' + row.id_factura +'"><i class="fa fa-eye"></i></a>' +
                            '<a href="#" class="btn-eliminar_factura" data-id="' + row.id_factura + '" title="Eliminar Factura">' +
                                '<i class="fa fa-trash"></i>' +
                                '</a></td>' +
                            '</tr>';
                    });

                    // Inserta las filas en la tabla de facturas de compras
                    $('#tablaFacturasCompras tbody').html(tableRows);

                    // Inicializa DataTables
                    $('#tablaFacturasCompras').DataTable({
                        dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                            "<'row'<'col-md-12'tr>>" +
                            "<'row'<'col-md-6'i><'col-md-6'p>>",
                        language: {
                            url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                        },
                        buttons: [
                        {
                            extend: 'excelHtml5',
                            text: '<i class="fa-solid fa-file-excel"></i> Exportar a Excel',
                            filename: 'facturas_compras',
                            exportOptions: {
                                columns: [2, 3, 5, 6, 7]
                            }
                        },
                        {
                            extend: 'pdfHtml5',
                            text: '<i class="fa-solid fa-file-pdf"></i> Exportar a PDF',
                            filename: 'facturas_compras',
                            exportOptions: {
                                columns: [2, 3, 5, 6, 7]
                            }
                        }
                    ]
                    });
                },
                error: function (error) {
                    console.log(error);
                }
                
            });
            // evento para filtrar por fecha
            $('#filtroFecha').on('change', function () {
                // Obtiene el valor del filtro
                const filtroFecha = $(this).val();

                // Si el filtro no tiene valor, no se hace nada
                if (filtroFecha === '') {
                    //reiniciar el datatable
                    $('#tablaFacturasCompras').DataTable().destroy();
                    return;
                }

                // Filtra los registros de la tabla
                $('#tablaFacturasCompras').DataTable().column(4).search(filtroFecha).draw();
            });

            // evento para filtrar por paciente
            $('#filtroProveedor').on('change', function () {
                // Obtiene el valor del filtro
                const filtroProveedor = $(this).val();

                // Si el filtro no tiene valor, no se hace nada
                if (filtroProveedor === 'Todos') {
                    //reiniciar el datatable
                    $('#tablaFacturasCompras').DataTable().destroy();
                    return;
                }

                // Filtra los registros de la tabla
                $('#tablaFacturasCompras').DataTable().column(1).search(filtroProveedor).draw();
            });

            $(document).on('click', '.btn-eliminar_factura', function () {
            if (confirm('¿Estás seguro de eliminar esta factura?')) {
                const idFactura = $(this).data('id');

                $.ajax({
                    url: 'eliminar_factura_compra.php',
                    method: 'POST',
                    data: {
                        idFactura: idFactura
                    },
                    success: function (response) {
                        const data = JSON.parse(response);

                        if (data.success) {
                            alert('Factura eliminada correctamente');
                            location.reload();
                        } else {
                            alert('Error al eliminar la factura');
                        }
                    },
                    error: function (error) {
                        console.log(error);
                    }
                });
            }
        });
        });
    </script>
</body>
</html>
