<?php
session_start();

if (!isset($_SESSION["nombre_usuario"])) {
    header("Location: iniciar_sesion.php");
    exit();
}


include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Mostrar mensajes de error o éxito
if (isset($_GET['error'])) {
    $error = $_GET['error'];
    switch ($error) {
        case 'orden_no_encontrada':
            $mensajeError = 'La orden de estudio no fue encontrada.';
            break;
        case 'resultados_cargados':
            $mensajeExito = 'Los resultados médicos han sido cargados exitosamente.';
            break;            
        case 'error_cargar_resultados':
            $mensajeError = 'Error al cargar los resultados médicos.';
            break;
    }
}

$detalleOrden = null;
$resultadosCargados = 0;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $numeroOrden = $_POST["numero_orden"];

    // Buscar detalles de la orden de estudio
    $sqlDetalleOrden = "SELECT oe.id_orden_estudio, oe.id_cliente, oe.id_usuario, oe.fecha, oe.observacion, 
                                c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula AS cedula_paciente, c.fecha_nacimiento AS fecha_nacimiento, 
                                u.nombre AS nombre_medico, u.apellido AS apellido_medico, oo.id_orden_estudio as id_orden_ordenes, oo.id_estudio as id_estudio_ordenes,
                                e.nombre_estudio as nombre_estudio, e.precio as precio_estudio
                        FROM ordenes_estudios oe
                        JOIN ordenes_estudios_estudios oo ON oe.id_orden_estudio = oo.id_orden_estudio
                        JOIN estudios_medicos e ON oo.id_estudio = e.id_estudio
                        JOIN clientes c ON oe.id_cliente = c.id_cliente
                        JOIN usuarios u ON oe.id_usuario = u.id_usuario
                        WHERE oe.id_orden_estudio = ?";
    $stmtDetalleOrden = $conn->prepare($sqlDetalleOrden);
    $stmtDetalleOrden->bind_param("i", $numeroOrden);
    $stmtDetalleOrden->execute();
    $resultDetalleOrden = $stmtDetalleOrden->get_result();

    // Verificar si la orden de estudio existe
    if ($resultDetalleOrden->num_rows > 0) {
        $detalleOrden = $resultDetalleOrden->fetch_assoc();

        // Verificar si ya existen resultados médicos
        $sqlResultadosCargados = "SELECT COUNT(*) as cantidad FROM resultados_medicos WHERE id_orden_estudio = ?";
        $stmtResultadosCargados = $conn->prepare($sqlResultadosCargados);
        $stmtResultadosCargados->bind_param("i", $detalleOrden['id_orden_estudio']);
        $stmtResultadosCargados->execute();
        $resultCargados = $stmtResultadosCargados->get_result();

        if ($resultCargados->num_rows > 0) {
            $rowCargados = $resultCargados->fetch_assoc();
            $resultadosCargados = $rowCargados['cantidad'];
        }
    } else {
        // Orden de estudio no encontrada
        header("Location: cargar_resultados.php?error=orden_no_encontrada");
        exit();
    }

    $stmtDetalleOrden->close();
    $stmtResultadosCargados->close();
}

// Calcular la cantidad de archivos adicionales permitidos
$archivosPermitidos = 10 - $resultadosCargados;

// Obtener archivos ya cargados
$sqlArchivosCargados = "SELECT id_resultado, nombre_archivo, ruta_archivo, tipo_archivo FROM resultados_medicos WHERE id_orden_estudio = ?";
$stmtArchivosCargados = $conn->prepare($sqlArchivosCargados);
$stmtArchivosCargados->bind_param("i", $detalleOrden['id_orden_estudio']);
$stmtArchivosCargados->execute();
$resultArchivosCargados = $stmtArchivosCargados->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Cargar Resultados</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Cargar Resultados Médicos</h2>
                        </div>

                        <div class="card-body">
                            <!-- Mostrar mensajes de éxito o error -->
                            <?php if (isset($mensajeExito)) : ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo $mensajeExito; ?>
                                </div>
                            <?php endif; ?>
                            <?php if (isset($mensajeError)) : ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo $mensajeError; ?>
                                </div>
                            <?php endif; ?>

                            <!-- Formulario para buscar orden de estudio -->
                            <form action="cargar_resultados.php" method="post">
                                <div class="mb-3">
                                    <label for="numeroOrden">Número de Orden de Estudio:</label>
                                    <input type="text" class="form-control" id="numeroOrden" name="numero_orden" placeholder="Introduce el número de orden" required>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <button type="submit" class="btn btn-primary">Buscar Detalles</button>
                                </div>
                            </form>

                            <!-- Mostrar detalles de la orden de estudio si existe -->
                            <?php if ($detalleOrden) : ?>
                                <h4 class="mt-4">Detalles de la Orden de Estudio</h4>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Orden N°</th>
                                            <th>Fecha</th>
                                            <th hidden>ID Cliente</th>
                                            <th hidden>ID Usuario</th>
                                            <th>Paciente</th>
                                            <th>Médico</th>
                                            <th hidden>ID Estudio</th>
                                            <th>Estudio</th>
                                            <th hidden>Precio Estudio</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo $detalleOrden['id_orden_estudio']; ?></td>
                                            <td><?php echo $detalleOrden['fecha']; ?></td>
                                            <td hidden><?php echo $detalleOrden['id_cliente']; ?></td>
                                            <td hidden><?php echo $detalleOrden['id_usuario']; ?></td>
                                            <td><?php echo $detalleOrden['nombre_paciente']; ?> <?php echo $detalleOrden['apellido_paciente']; ?></td>
                                            <td><?php echo $detalleOrden['nombre_medico']; ?><?php echo $detalleOrden['apellido_medico']; ?></td>
                                            <td hidden><?php echo $detalleOrden['id_estudio_ordenes']; ?></td>
                                            <td colspan="3">
                                                <!-- Mostrar estudios asociados a la orden de estudio -->
                                                <?php
                                                $idOrdenEstudio = $detalleOrden['id_orden_estudio'];
                                                $sqlEstudios = "SELECT e.nombre_estudio, e.precio 
                                                                FROM ordenes_estudios_estudios oo
                                                                JOIN estudios_medicos e ON oo.id_estudio = e.id_estudio
                                                                WHERE oo.id_orden_estudio = ?";
                                                $stmtEstudios = $conn->prepare($sqlEstudios);
                                                $stmtEstudios->bind_param("i", $idOrdenEstudio);
                                                $stmtEstudios->execute();
                                                $resultEstudios = $stmtEstudios->get_result();

                                                if ($resultEstudios->num_rows > 0) {
                                                    echo "<ul>";
                                                    while ($rowEstudio = $resultEstudios->fetch_assoc()) {
                                                        echo "<li>{$rowEstudio['nombre_estudio']} ({$rowEstudio['precio']})</li>";
                                                    }
                                                    echo "</ul>";
                                                } else {
                                                    echo "No se encontraron estudios asociados.";
                                                }

                                                $stmtEstudios->close();
                                                ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                                <!-- Mostrar archivos ya cargados -->
                                <?php if ($resultadosCargados > 0) : ?>
                                    <h4 class="mt-4">Resultados Médicos Cargados:</h4>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Nombre de Archivo</th>
                                                <th>Tipo de Archivo</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while ($rowArchivo = $resultArchivosCargados->fetch_assoc()) : ?>
                                                <tr>
                                                    <td><?php echo $rowArchivo['nombre_archivo']; ?></td>
                                                    <td><?php echo $rowArchivo['tipo_archivo']; ?></td>
                                                    <td>
                                                        <a href="ver_resultado.php?id_orden=<?php echo $detalleOrden['id_orden_estudio']; ?>&nombre_archivo=<?php echo $rowArchivo['nombre_archivo']; ?>" target="_blank" class="btn btn-info btn-sm">Ver Detalles</a>
                                                        <button class="btn btn-danger btn-sm btn-eliminar" data-id="<?php echo $rowArchivo['id_resultado']; ?>">Eliminar</button>
                                                    </td>

                                                </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                <?php endif; ?>

                                <!-- Formulario para cargar resultados médicos -->
                                <form action="procesar_cargar_resultados.php" method="post" enctype="multipart/form-data">
                                    <input type="hidden" name="id_orden_estudio" value="<?php echo $detalleOrden['id_orden_estudio']; ?>">
                                    <input type="hidden" name="id_cliente" value="<?php echo $detalleOrden['id_cliente']; ?>">
                                    

                                    <h4 class="mt-4">Cargar Resultados Médicos:</h4>
                                    <div class="mb-3">
                                        <label for="resultados">Cargar hasta 10 archivos (puedes cargar <?php echo $archivosPermitidos; ?> archivos más):</label>
                                        <input type="file" class="form-control" id="resultados" name="resultados[]" accept=".jpg, .png, .pdf" multiple required>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <button type="submit" class="btn btn-primary">Cargar Resultados</button>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script>
    $(document).ready(function() {
        $(".btn-eliminar").click(function() {
            if (confirm("¿Estás seguro de eliminar este archivo?")) {
                var idArchivo = $(this).data("id");

                $.ajax({
                    url: "eliminar_archivo.php",
                    type: "POST",
                    data: { idArchivo: idArchivo },
                    dataType: "json",
                    success: function(response) {
                        if (response.success) {
                            alert("Archivo eliminado correctamente.");
                            location.reload();
                        } else {
                            alert("Error al eliminar el archivo.");
                        }
                    },
                    error: function() {
                        alert("Error al eliminar el archivo.");
                    }
                });
            }
        });
    });
</script>


</body>
</html>
