<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión

if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// funcion para insertar registros y mostrar errores de consulta si hubieran
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $categoria_estudio_medico = $_POST["categoria_estudio_medico"];
    // Puedes agregar más campos según la estructura de tu base de datos

    // Inserta el nuevo estudio medico en la base de datos

    $stmt = $conn->prepare("INSERT INTO categoria_estudios (nombre_categoria_estudio) VALUES (?)");

    if ($stmt === false) {
        die('Error de preparación de la consulta: ' . $conn->error);
    }

    $stmt->bind_param("s", $categoria_estudio_medico);
    $exitoInsercion = $stmt->execute();

    if($exitoInsercion){
        // Redirige a la página de estudio medico con un mensaje de éxito en alert
        echo "<script>alert('Categoria de estudio médico agregado exitosamente'); window.location.href='categoria_estudios.php';</script>";
        exit();
    } else {
        // Redirige a la página de estudio medico con un mensaje de error
        header("Location: categoria_estudios.php");
        exit();
    }
    $stmt->close();
}



?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registrar Categoria de Estudio</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registrar Categoria de Estudio Médico</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <div class="mb-3">
                                    <label for="estudio_medcategoria_estudio_medicoico">Categoria de Estudio Médico</label>
                                    <input type="text" class="form-control" id="categoria_estudio_medico" name="categoria_estudio_medico" placeholder="Escribe la categoria p/ estudio médico" required>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <a href="categoria_estudios.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Registrar Categoria de Estudio</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    </body>
</html>

