<?php
// Inicia la sesión
session_start();

include 'conexion.php';

// Verifica si se recibieron datos por POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Recupera los datos del formulario
    $email = $_POST["email"];
    $password = $_POST["password"];

    // Realiza la autenticación
    if (autenticarUsuario($email, $password)) {
        // Autenticación exitosa
        $_SESSION["email"] = $email; // Almacena el correo electrónico en la sesión
        $_SESSION["nombre_usuario"] = obtenerNombreUsuario($email); // Almacena el nombre de usuario en la sesión
        $_SESSION["id_usuario"] = obtenerUsuarioPorEmail($email)["id_usuario"]; // Almacena el id de usuario en la sesión
        header("Location: ../../pages/dashboard.php"); // Redirige al dashboard
        exit();
    } else {
        // Autenticación fallida
        echo "Error de autenticación: Usuario o contraseña incorrectos.";
    }
} else {
    // Si alguien intenta acceder directamente a este script sin enviar datos por POST, redirige a la página de inicio
    header("Location: ../../index.php");
    exit();
}

// Función para autenticar al usuario
function autenticarUsuario($email, $password) {
    // Deberías realizar una consulta a la base de datos para verificar el correo y contraseña
    // Aquí, se utiliza una función ficticia obtenerUsuarioPorEmail para simular la obtención de datos del usuario

    $usuarioRegistrado = obtenerUsuarioPorEmail($email);

    // Verifica si el usuario existe y la contraseña es válida
    if ($usuarioRegistrado && password_verify($password, $usuarioRegistrado["contrasena"])) {
        return true; // Autenticación exitosa
    }

    return false; // Autenticación fallida
}

// Función para obtener un usuario por su correo electrónico
function obtenerUsuarioPorEmail($email) {
    // Realiza la consulta a la base de datos para obtener los datos del usuario según el correo electrónico
    // Utiliza parámetros preparados para prevenir la inyección SQL

    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    $stmt = $conn->prepare("SELECT correo, contrasena FROM usuarios WHERE correo = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();

    // Obtiene el resultado de la consulta
    $result = $stmt->get_result();

    // Verifica si se encontró un usuario
    if ($result->num_rows > 0) {
        $usuario = $result->fetch_assoc();
        $stmt->close(); // Cierra la declaración
        $conexionDB->desconectar($conn); // Cierra la conexión
        return $usuario; // Devuelve el usuario encontrado
    }

    $stmt->close(); // Cierra la declaración
    $conexionDB->desconectar($conn); // Cierra la conexión
    return null; // Si no se encuentra el usuario
}

// Función para obtener el nombre del usuario
function obtenerNombreUsuario($email) {
    // Deberías realizar una consulta a la base de datos para obtener el nombre del usuario
    // En este ejemplo, simplemente devolvemos un nombre ficticio

    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    $stmt = $conn->prepare("SELECT nombre_usuario FROM usuarios WHERE correo = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();

    // Obtiene el resultado de la consulta
    $result = $stmt->get_result();

    // Verifica si se encontró un usuario
    if ($result->num_rows > 0) {
        $nombreUsuario = $result->fetch_assoc()['nombre_usuario'];
        $stmt->close(); // Cierra la declaración
        $conexionDB->desconectar($conn); // Cierra la conexión
        return $nombreUsuario; // Devuelve el nombre de usuario encontrado
    }

    $stmt->close(); // Cierra la declaración
    $conexionDB->desconectar($conn); // Cierra la conexión
    return null; // Si no se encuentra el nombre de usuario
}
?>
