<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include 'conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $idUsuario = $_POST["idUsuario"];
    $username = $_POST["username"];
    $nombre = $_POST["nombre"];
    $apellido = $_POST["apellido"];
    $email = $_POST["email"];
    $rol = $_POST["rol"];
    $direccion = $_POST["direccion"];
    $telefono = $_POST["telefono"];
    $cedula = $_POST["cedula"];
    // Puedes agregar más campos según la estructura de tu base de datos

    // Verifica si se proporcionó una nueva imagen
    if (!empty($_FILES['imagen']['name'])) {
        $imagenTmpName = $_FILES['imagen']['tmp_name'];
        $imagenName = $_FILES['imagen']['name'];

        // Obtiene la extensión del archivo
        $extension = pathinfo($imagenName, PATHINFO_EXTENSION);

        // Verifica si la extensión es jpg o png
        if (strtolower($extension) == 'jpg' || strtolower($extension) == 'png') {
            // Mueve la nueva imagen a la carpeta deseada
            $rutaNuevaImagen = '../imagenes_usuarios/' . $imagenName;
            move_uploaded_file($imagenTmpName, $rutaNuevaImagen);

            // Inserta la información de la imagen en la tabla de imágenes
            $sqlInsertImagen = "INSERT INTO imagenes (nombre_archivo, fecha_subida) VALUES ('$imagenName', NOW())";
            $conn->query($sqlInsertImagen);

            $idImagen = $conn->insert_id;
        } else {
            // Si la extensión no es válida, emite un mensaje de error
            echo "<script>alert('Solo se permiten archivos JPG o PNG.'); history.back();</script>";
            exit();
        }
    } else {
        // Si no se proporcionó una nueva imagen, conserva el ID de imagen existente
        $idImagen = $_POST['idImagenExistente']; // Asegúrate de que este campo esté presente en tu formulario
    }

    // Actualiza el usuario en la base de datos
    $sql = "UPDATE usuarios SET nombre_usuario = '$username', nombre = '$nombre', apellido = '$apellido', correo = '$email', direccion = '$direccion', telefono = '$telefono', cedula = '$cedula', id_rol = '$rol', id_imagen = " . ($idImagen ? "'$idImagen'" : "id_imagen") . " WHERE id_usuario = $idUsuario";

    if (ejecutarConsulta($sql)) {
        // Redirige a la página de usuarios con un mensaje de éxito
        header("Location: ../../pages/usuarios.php?success=Usuario actualizado exitosamente");
        exit();
    } else {
        // Redirige a la página de usuarios con un mensaje de error
        header("Location: ./../pages/usuarios.php?error=Error al actualizar el usuario");
        exit();
    }
} else {
    // Si no es una solicitud POST, redirige a la página de usuarios
    header("Location: ../../pages/usuarios.php");
    exit();
}
?>
