<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../assets/PHPMailer-master/src/Exception.php';
require '../assets/PHPMailer-master/src/PHPMailer.php';
require '../assets/PHPMailer-master/src/SMTP.php';

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

function generarToken()
{
    return bin2hex(random_bytes(32));
}

function enviarCorreo($email, $token)
{
    $mail = new PHPMailer(true);

    try {
        // Configuración del servidor SMTP
        $mail->isSMTP();
        $mail->Host = 'dentox.com.py';
        $mail->SMTPAuth = true;
        $mail->Username = 'sistema@dentox.com.py';
        $mail->Password = '$istema$12345';
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        // Configuración del correo
        $mail->setFrom('sistema@dentox.com.py', 'Dentox - Sistema');
        $mail->addAddress($email);

        // Contenido del correo
        $mail->isHTML(true);
        $mail->Subject = 'Recuperación de Contraseña';
        $mail->Body = "Hola,<br><br>Para restablecer tu contraseña, haz clic en el siguiente enlace:<br><br>";
        $mail->Body .= "<a href='http://dentox.com.py/restablecer_contraseña.php?token=$token'>Restablecer Contraseña</a>";

        $mail->send();

        return true;
    } catch (Exception $e) {
        return false;
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST["email"];

    // Verificar si el correo existe en la base de datos
    $sql = "SELECT * FROM usuarios WHERE correo = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $usuario = $result->fetch_assoc();

        // Generar token
        $token = generarToken();

        // Almacenar token en la base de datos
        $sqlUpdateToken = "UPDATE usuarios SET token_reset = ?, token_reset_expira = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE id_usuario = ?";
        $stmtUpdateToken = $conn->prepare($sqlUpdateToken);
        $stmtUpdateToken->bind_param("si", $token, $usuario['id_usuario']);
        $stmtUpdateToken->execute();

        if ($stmtUpdateToken->affected_rows > 0) {
            // Enviar correo con el enlace de recuperación
            if (enviarCorreo($email, $token)) {
                echo json_encode(["success" => true, "message" => "Se ha enviado un enlace de recuperación a tu correo electrónico."]);
            } else {
                echo json_encode(["success" => false, "error" => "Error al enviar el correo de recuperación."]);
            }
        } else {
            echo json_encode(["success" => false, "error" => "Error al actualizar el token en la base de datos."]);
        }

        $stmtUpdateToken->close();
    } else {
        echo json_encode(["success" => false, "error" => "No se encontró un usuario con ese correo electrónico."]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "error" => "Método no permitido."]);
}

$conn->close();
?>
