<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Consulta para obtener todas las facturas pendientes (contado y crédito)
$sqlFacturasPendientes = "SELECT fv.id_factura, fv.id_usuario, fv.id_cliente, fv.condicion_venta, fv.plazo_en_dias, fv.estado, c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula as cedula_paciente, fv.fecha, fv.numero_factura, fv.importe_total, u.nombre_usuario
                          FROM facturas_ventas fv
                          INNER JOIN usuarios u ON fv.id_usuario = u.id_usuario
                          INNER JOIN clientes c ON fv.id_cliente = c.id_cliente
                          WHERE fv.estado = 'pendiente'";

$resultadoFacturasPendientes = ejecutarConsulta($sqlFacturasPendientes);

// Crear un array para almacenar los resultados
$facturasPendientes = array();

// Recorrer los resultados y agregarlos al array
while ($fila = $resultadoFacturasPendientes->fetch_assoc()) {
    $factura = array(
        'id_factura' => $fila['id_factura'],
        'id_usuario' => $fila['id_usuario'],
        'id_cliente' => $fila['id_cliente'],
        'nombre_paciente' => $fila['nombre_paciente'],
        'apellido_paciente' => $fila['apellido_paciente'],
        'cedula_paciente' => $fila['cedula_paciente'],
        'fecha' => $fila['fecha'],
        'numero_factura' => $fila['numero_factura'],
        'importe_total' => $fila['importe_total'],
        'nombre_usuario' => $fila['nombre_usuario'],
        'condicionFactura' => $fila['condicion_venta'],
        'plazo_en_dias' => $fila['plazo_en_dias'],
        'fecha_vencimiento' => '',  // Se calculará más adelante
        'estado' => $fila['estado'],
        'atrasada' => true,  // Inicialmente se asume que la factura está atrasada
        'cuotas' => array(),  // Array para almacenar cuotas asociadas a la factura
    );

    // si la cuota es contado, entonces la fecha de vencimiento es la misma fecha de la factura
    if ($factura['condicionFactura'] === 'Contado') {
        $factura['fecha_vencimiento'] = $factura['fecha'];
    }

    // Obtener las cuotas asociadas a la factura
    $sqlCuotasFactura = "SELECT numero_cuota, fecha_vencimiento, monto_cuota, estado, id_cuota
                         FROM cuotas_factura
                         WHERE id_factura = {$factura['id_factura']}";
    $resultadoCuotasFactura = ejecutarConsulta($sqlCuotasFactura);

    // Recorrer las cuotas y agregarlas al array de cuotas en la factura
    while ($filaCuota = $resultadoCuotasFactura->fetch_assoc()) {        
        $fechaVencimientoCuota = $filaCuota['fecha_vencimiento'];
        $fechaActual = date('Y-m-d');

        // calcular el valor de dias de atraso si la fecha de vencimiento es menor a la fecha actual
        $dias_atraso = 0;
        if ($fechaVencimientoCuota < $fechaActual) {
            $datetime1 = new DateTime($fechaVencimientoCuota);
            $datetime2 = new DateTime($fechaActual);
            $interval = $datetime1->diff($datetime2);
            $dias_atraso = abs($interval->format('%R%a'));
            $atrasada = true;
        }else{
            $dias_atraso = 0;
            $atrasada = false;
        }

        $cuota = array(
            'numero_cuota' => $filaCuota['numero_cuota'],
            'fecha_vencimiento' => $filaCuota['fecha_vencimiento'],
            'monto_cuota' => $filaCuota['monto_cuota'],
            'atrasada' => $atrasada,  
            'dias_atraso' => $dias_atraso,
            'estado' => $filaCuota['estado'],
            'id_cuota' => $filaCuota['id_cuota'],
        );

        $factura['cuotas'][] = $cuota;
    }

    // verificar si en el array de cuotas, existe una cuota atrasada, entonces actualizar el array de facturas la clave de atrasada a true

    foreach ($factura['cuotas'] as $cuota) {
        if ($cuota['atrasada'] === true) {
            $factura['atrasada'] = true;
            break;
        }
    }

    $facturasPendientes[] = $factura;
}

// Devolver el array en formato JSON
header('Content-Type: application/json');
echo json_encode(array('facturasPendientes' => $facturasPendientes));

// Cerrar la conexión
$conn->close();
?>
