<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Incluir el archivo de conexión
include '../assets/includes/conexion.php';

// Verificar si se recibieron los datos esperados
if (
    isset($_POST['idFactura'], $_POST['idEstudioMedico'], $_POST['observacion'], $_POST['importeTotal'])
) {
    // Obtener los datos del formulario
    $idFactura = $_POST['idFactura'];
    $idEstudioMedico = $_POST['idEstudioMedico'];
    $observacion = $_POST['observacion'];
    $importeTotal = $_POST['importeTotal'];

    // Crear una instancia de la clase de conexión
    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    // Preparar la consulta SQL para insertar en la tabla detalle_factura_venta
    $sql = "INSERT INTO detalle_factura_venta (id_factura_venta, id_estudios, observacion, importe_total) VALUES (?, ?, ?, ?)";

    // Preparar la sentencia
    $stmt = $conn->prepare($sql);

    // Vincular los parámetros
    $stmt->bind_param("iisd", $idFactura, $idEstudioMedico, $observacion, $importeTotal);

    // Ejecutar la sentencia
    if ($stmt->execute()) {
        // Devolver una respuesta exitosa (puedes personalizar según tus necesidades)
        echo json_encode(["success" => true, "message" => "Detalle de factura de venta guardado correctamente."]);
    } else {
        // Manejar el error si la ejecución de la sentencia falla
        echo json_encode(["success" => false, "message" => "Error al insertar el detalle de factura de venta: " . $stmt->error]);
    }

    // Cerrar la conexión y liberar recursos
    $stmt->close();
    $conn->close();
} else {
    // Si no se recibieron los datos esperados, devolver un mensaje de error
    echo json_encode(["success" => false, "message" => "Error: Datos incompletos o incorrectos."]);
}
?>
