<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Procesar formulario de edicion de estado
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["idEstado"])) {
    // Obtén el ID del rol a editar
    $idEstado = $_POST["idEstado"];

    // Obtén los datos del formulario
    $nombreEstado = $_POST["nombreEstado"];

    // Actualiza el rol en la base de datos utilizando una consulta preparada
    $sql = "UPDATE estados_agendamientos SET nombre_estado = ? WHERE id_estado = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $nombreEstado, $idEstado);
    $resultado = $stmt->execute();
    $stmt->close(); // Cierra el statement después de usarlo

    if ($resultado) {
        // Devuelve una respuesta JSON indicando éxito
        header("Location: estado_agendamiento.php");
        exit();
    } else {
        // Devuelve una respuesta JSON indicando error
        header("Location: estado_agendamiento.php");
        exit();
    }
}

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["id"])) {
    // Obtén el ID del rol a editar
    $idEstado = $_GET["id"];

    // Obtén la información del rol desde la base de datos
    $sql = "SELECT * FROM estados_agendamientos WHERE id_estado = $idEstado";
    $resultado = ejecutarConsulta($sql);

    if ($resultado->num_rows > 0) {
        $estado = $resultado->fetch_assoc();
        
    } else {
        // Si no se encuentra el rol, redirige a la página de roles
        header("Location: estado_agendamiento.php");
        exit();
    }
} else {
    // Si no se proporciona un ID válido, redirige a la página de roles
    header("Location: estado_agendamiento.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Editar Estado</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Editar Estado</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <!-- Agrega los campos de edición del rol con los valores obtenidos de la base de datos -->
                                <input type="hidden" name="idEstado" value="<?php echo $estado['id_estado']; ?>">
                                <div class="mb-3">
                                    <label for="nombreEstado">Nombre del Estado</label>
                                    <input type="text" class="form-control" id="nombreEstado" name="nombreEstado" value="<?php echo $estado['nombre_estado']; ?>" required>
                                </div>
                                <!-- Otros campos de edición según la estructura de tu base de datos -->

                                <div class="d-flex justify-content-between">
                                    <a href="estado_agendamiento.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Actualizar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>
</body>
</html>
