<?php

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}


// Incluye el archivo de conexión
include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}


// Obtener la lista de categorias
function obtenerCategorias()
{
    $sql = "SELECT * FROM categoria_cliente";
    return ejecutarConsulta($sql);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Tus enlaces CSS existentes -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Listado de Categorias</h2>
                            <a href="agregar_categoria.php">
                            <button type="button" class="btn btn-primary" href="agregar_categoria.php"> 

                            Agregar Nueva Categoría

                            </button>
                            </a>
                        </div>
                        <div class="card-body table-responsive">
                            <table id="tablaCategorias" class="table">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Nombre</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $categorias = obtenerCategorias();

                                    while ($categoria = $categorias->fetch_assoc()) {
                                        echo "<tr>
                                                <td>{$categoria['id_categoria']}</td>
                                                <td>{$categoria['nombre_categoria']}</td>

                                                <td>
                                                <a href='#' class='btn-editar' title='Editar'>
                                                    <i class='fa fa-edit'></i>
                                                </a>
                                                <a href='#' class='btn-borrar' title='Borrar'>
                                                    <i class='fa fa-minus' style='color:red;'></i>
                                                </a>
                                            </td>
                                            </tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <!-- Modal para agregar categoría -->
    <div class="modal fade" id="modalAgregarCategoria" tabindex="-1" aria-labelledby="modalAgregarCategoriaLabel" aria-hidden="true">
        <!-- Agrega aquí el contenido del modal -->
    </div>

    <!-- Modal para editar categoría -->
    <div class="modal fade" id="modalEditarCategoria" tabindex="-1" aria-labelledby="modalEditarCategoriaLabel" aria-hidden="true">
        <!-- Agrega aquí el contenido del modal -->
    </div>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script de DataTables -->
    <script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.html5.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.dataTables.min.css">

    <script>
        $(document).ready(function () {
            // Inicializar el DataTable
            $('#tablaCategorias').DataTable({
                dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                    "<'row'<'col-md-12'tr>>" +
                    "<'row'<'col-md-6'i><'col-md-6'p>>",
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                },
                buttons: [
                    {
                        extend: 'excelHtml5',
                        text: 'Exportar a Excel',
                        exportOptions: {
                            columns: ':visible'
                        }
                    }
                ],
                responsive: true
            });
            // Agregar evento para editar la categoria
            $('#tablaCategorias').on('click', '.btn-editar', function () {
                // Obtiene la fila que contiene los datos de la cateria
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idCategoria = $tr.find("td:eq(0)").text();

                // Redirecciona a la página de edición de la categoria
                window.location.href = 'editar_categoria.php?id=' + idCategoria;
            });

            // Agregar evento para eliminar la categoria
            $('#tablaCategorias').on('click', '.btn-borrar', function () {
                // Obtiene la fila que contiene los datos del cliente
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idCategoria = $tr.find("td:eq(0)").text();
                var nombreCategoria = $tr.find("td:eq(1)").text();
                
                // Pregunta al usuario si desea eliminar la categoria
                if (confirm("¿Estás seguro de eliminar la categoria: " + nombreCategoria +" ?")) {
                    // Elimina la categoria
                    $.ajax({
                        url: '../assets/includes/eliminar_categoria.php',
                        type: 'POST',
                        data: { idCategoria: idCategoria },
                        success: function (response) {
                            // Verifica si se eliminó la categoria
                            if (JSON.parse(response).success) {
                                // Elimina la fila de la tabla
                                $tr.remove();
                            } else {
                                // Muestra un mensaje de error
                                alert(JSON.parse(response).message);
                            }
                        }
                    });
                }
            });

        });
    </script>
</body>
</html>
