<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// obtener el id del usuario mediante consulta
$sqlidusuario = "SELECT id_usuario FROM usuarios WHERE nombre_usuario = '" . $_SESSION["nombre_usuario"] . "'";
$resultadoidusuario = $conn->query($sqlidusuario);

if ($resultadoidusuario->num_rows > 0) {
    while ($row = $resultadoidusuario->fetch_assoc()) {
        $idUsuariosearch = $row["id_usuario"];
    }
} else {
    echo "0 results";
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Facturas de Ventas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    
</head>
<body>

    <?php include '../assets/includes/navegacion.php'; ?>

    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registro de Factura de Ventas</h2>
                        </div>
                        <div class="card-body">

                            <!-- Mostrar datos del proveedor -->
                            <div class="container">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                        <div class="mb-4">
                                            <h3 style="color: #4664B5;">Datos del Paciente</h3>
                                            
                                            <hr width="100%" style="color: #999999;"/>
                                                <div class="mb-3">
                                                    <label for="buscar-paciente">Paciente</label>
                                                        <br>
                                                        <select id="buscar-paciente" class="btn btn-outline btn-lg" required>
                                                            <option value="" selected disabled>Buscar Paciente por Nombre o RUC</option>
                                                        </select>
                                                        <!-- Agrega un campo oculto para almacenar el idUsuario -->
                                                        <input type="hidden" id="idPaciente" name="idPaciente">
                                                        <!-- Agrega el botón o texto con el enlace "Crear Paciente" -->
                                                        <br>
                                                        <a href="agregar_clientes.php">Crear Paciente</a>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="nombrePaciente">Nombre del Paciente</label>
                                                    <input type="text" class="form-control" id="nombrePaciente" name="nombrePaciente" disabled>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="rucPaciente">RUC o C.I: </label>
                                                    <input type="text" class="form-control" id="rucPaciente" name="rucPaciente" disabled>
                                                </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-4">
                                            <!-- Datos del seguro -->
                                            <h3 style="color: #4664B5;">Datos de la factura</h3>
                                            <hr width="100%" style="color: #999999;"/>
                                                <div class="mb-3">
                                                    <label for="fechaFactura">Fecha de Factura</label>
                                                    <input type="date" class="form-control" id="fechaFactura" name="fechaFactura" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="timbradoFactura">Timbrado de la Factura</label>
                                                    <input type="text" class="form-control" id="timbradoFactura" name="timbradoFactura" placeholder="Introduce el Timbrado de la factura" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="numeroFactura">Número de Factura</label>
                                                    <input type="text" class="form-control" id="numeroFactura" name="numeroFactura" placeholder="Introduce el número de factura" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="condicionFactura">Condición</label>
                                                    <select class="form-select" id="condicionFactura" name="condicionFactura" required>
                                                        <option value="Contado" selected>Contado</option>
                                                        <option value="Crédito">Crédito</option>
                                                    </select>
                                                </div>

                                                <div class="mb-3" id="divCuotas" style="display: none;">
                                                    <label for="cuotas">Cantidad de Cuotas</label>
                                                    <input type="number" class="form-control" id="cuotas" name="cuotas" value="1">                                                    
                                                </div>

                                        </div>

                                    </div>
                                </div>
                                <hr width="100%" style="color: #999999;"/>
                            </div>

                            <!-- Sección para agregar las líneas de factura -->
                            <div class="mb-12">
                                <h3 style="color: #4664B5;">Líneas de Factura</h3>
                                <hr width="100%" style="color: #999999;"/>

                                <div class="d-flex align-items-center">
                                    <!-- Botones para agregar nueva línea y obtener estudios -->
                                    <button class="btn btn-success me-3" id="btnAgregarLinea">
                                        <i class="fas fa-plus"></i> Agregar Línea
                                    </button>

                                    <button class="btn btn-primary me-3" id="btnObtenerEstudios">
                                        <i class="fas fa-plus"></i> Obtener Estudios
                                    </button>

                                    <!-- Campo para ingresar la orden de estudio -->
                                    <label class="me-2" for="obtenerOrdenEstudio">Orden de Estudio: </label>
                                    <input type="number" id="obtenerOrdenEstudio" name="obtenerOrdenEstudio">
                                </div>


                                <!-- Tabla para mostrar las líneas de factura -->
                                <table class="table table-bordered" id="tablaLineasFactura">
                                    <thead>
                                        <tr>
                                            <th>Concepto</th>
                                            <th hidden>Costo Original</th>
                                            <th>Costo</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Aquí se agregarán las filas dinámicamente -->
                                    </tbody>
                                </table>
                            
                                <div class="mb-3">
                                    <label for="totalFactura">Total de la Factura</label>
                                    <input type="hidden" class="form-control" id="totalFacturaOriginal" name="totalFacturaOriginal" placeholder="Total" disabled>    
                                    <input type="number" class="form-control" id="totalFactura" name="totalFactura" placeholder="Total" disabled>
                                </div>


                            </div>

                            <!-- Sección del boton guardar factura -->
                            <div class="mb-12">
                                <div class="btn-group">
                                    <button class="btn btn-primary" id="btnGuardarFactura">
                                        <i class="fas fa-save"></i> Guardar Factura
                                    </button>
                                    <button class="btn btn-primary" id="btnNuevaFactura" style="display: none;">
                                        <i class="fas fa-plus"></i> Nueva Factura
                                    </button>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>


    <!-- Scripts al final para mejorar la carga de la página -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2Xof8+cu6Qr5I5Ih0k5r4aFslw8Z5Gz0D93Q" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/js/select2.min.js"></script>
    <script src="../assets/js/c hosen.jquery.min.js"></script>
    
    <script>
        $(document).ready(function() {

            // Agrega un evento change al campo condicionFactura
            $('#condicionFactura').on('change', function () {
                // Verifica la selección actual
                if ($(this).val() === 'Crédito') {
                    // Si la condición es crédito, muestra el campo de cuotas
                    $('#divCuotas').show();
                } else {
                    // Si la condición es contado, oculta el campo de cuotas
                    $('#divCuotas').hide();
                }
            });
            // Inicializa el select2
            $('#buscar-paciente').select2({
                    ajax: {
                        type: 'POST',
                        url: 'buscar_clientes.php',
                        delay: 250,
                        data: function (params) {
                            return {
                                filtro: params.term,
                            };
                        },
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    return {
                                        text: item.nombre + ' ' + item.apellido + ' - RUC: ' + item.cedula,
                                        id: item.id_cliente,
                                        
                                    };
                                }),
                            };
                        },
                        cache: true,
                    },
                    placeholder: 'Buscar Paciente por Nombre o RUC',
                    minimumInputLength: 2,
                });

                // Agrega un evento change para capturar la selección
                $('#buscar-paciente').on('change', function (e) {
                    // Obtén el objeto de datos seleccionado
                    var selectedData = $('#buscar-paciente').select2('data')[0];

                    // Verifica si hay un objeto de datos seleccionado
                    if (selectedData) {
                        // Asigna los valores a los campos correspondientes
                        $('#idPaciente').val(selectedData.id);
                        $('#nombrePaciente').val(selectedData.text.split('-')[0].trim());
                        $('#rucPaciente').val(selectedData.text.split('-')[1].trim());
                    }
                });

                // en el campo de numero de factura se debe de completar de la siguiente manera xxx-xxx-xxxxxxx
                $('#numeroFactura').on('keyup', function (e) {
                    var numeroFactura = $('#numeroFactura').val();
                    var numeroFacturaFormateado = numeroFactura.replace(/(\d{3})(\d{3})(\d{7})/, "$1-$2-$3");
                    $('#numeroFactura').val(numeroFacturaFormateado);
                });

                // Contador para identificar las nuevas líneas de factura
                var contadorLineas = 1;

                // Evento al hacer clic en el botón Agregar Línea
                $('#btnAgregarLinea').on('click', function () {
                    // Agrega una nueva fila a la tabla
                    agregarFila();
                    // Incrementa el contador
                    contadorLineas++;

                    // Calcula el total de la factura
                    calcularTotalFactura();
                });

                // Evento al hacer clic en el botón Obtener Estudios
                $('#btnObtenerEstudios').on('click', function () {
                    var ordenEstudio = $('#obtenerOrdenEstudio').val();

                    // Verificar si el campo Orden de Estudio tiene un valor válido
                    if (ordenEstudio !== "" && ordenEstudio !== "0") {
                        // Realizar la consulta para obtener los estudios asociados a la orden
                        obtenerEstudiosPorOrden(ordenEstudio);
                    } else {
                        // Si el campo no tiene un valor válido, muestra un mensaje o realiza otra acción según sea necesario
                        alert('Ingrese un valor válido para la Orden de Estudio');
                    }
                });

                // Configura el evento click para el botón de eliminar línea fuera de la función agregarFila
                $(document).on('click', '.btnEliminarLinea', function () {
                    var idFila = $(this).data('id');
                    $('#fila' + idFila).remove();
                    calcularTotalFactura();

                });

                // funcion para agregar una nueva fila a la tabla
                function agregarFila() {
                    // Crea la nueva fila
                    var fila = '<tr id="fila' + contadorLineas + '">' +
                    '<td>' +
                    '<select class="form-select" id="estudioMedico' + contadorLineas + '" name="estudioMedico' + contadorLineas + '" required>' +
                    '<option value="" selected disabled>Seleccione un concepto...</option>' +
                    '</select>' +
                    '<input type="hidden" id="idestudioMedico' + contadorLineas + '" name="idestudioMedico' + contadorLineas + '">' +
                    '</td>' +
                    '<td>' +
                    '<input type="hidden" id="costoEstudioOriginal' + contadorLineas + '" name="costoEstudioOriginal' + contadorLineas + '">' +
                    '<input style="text-align:right;" type="number" class="form-control" id="costoEstudio' + contadorLineas + '" name="costoEstudio' + contadorLineas + '" placeholder="Total" readonly required>' +
                    '</td>' +
                    '<td>' +
                    '<button class="btn btn-danger btnEliminarLinea" data-id="' + contadorLineas + '"><i class="fas fa-trash"></i></button>' +
                    '</td>' +
                    '</tr>';

                    // Agrega la fila a la tabla
                    $('#tablaLineasFactura tbody').
                    append(fila);

                    // Inicializa select2 en la nueva fila
                    inicializarSelect2EnFila(contadorLineas);

                    // Calcula el total de la factura
                    calcularTotalFactura();
                }

                // Función para inicializar select2 en una fila específica
                function inicializarSelect2EnFila(idFila) {
                    $('#estudioMedico' + idFila).select2({
                        ajax: {
                            type: 'POST',
                            url: 'buscar_estudios.php',
                            delay: 250,
                            data: function (params) {
                                return {
                                    filtroEstudio: params.term,
                                };
                            },
                            processResults: function (data) {
                                return {
                                    results: $.map(data, function (item) {
                                        return {
                                            text: item.nombre_estudio,
                                            id: item.id_estudio,
                                            precio: item.precio,
                                        };
                                    }),
                                };
                            },
                            cache: true,
                        },
                        placeholder: 'Buscar Estudio',
                        minimumInputLength: 2,
                    });
                }

                // agregar un evento para capturar la seleccion de cuenta contable
                $(document).on('change', '[id^=estudioMedico]', function (e) {
                    // Obtén el objeto de datos seleccionado
                    var selectedData = $(this).select2('data')[0];

                    // Verifica si hay un objeto de datos seleccionado
                    if (selectedData) {
                        // Asigna los valores a los campos correspondientes
                        var idFila = $(this).attr('id').replace('estudioMedico', '');
                        $('#idestudioMedico' + idFila).val(selectedData.id);
                        $('#costoEstudioOriginal' + idFila).val(selectedData.precio);
                        // asignar el costo pero ya formateado con separadores de miles
                        $('#costoEstudio' + idFila).val(parseFloat(selectedData.precio).toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }));
                        
                        // Salida de depuración
                        console.log("idFila: ", idFila);
                        console.log("idEstudio: ", selectedData.id);
                        console.log("costo: ", selectedData.precio);

                        // Calcula el total de la factura
                        calcularTotalFactura();
                    }
                });

                // Función para obtener los estudios asociados a una orden
                function obtenerEstudiosPorOrden(idOrdenEstudio) {
                    // Realiza una petición AJAX para obtener los estudios asociados a la orden
                    $.ajax({
                        url: 'buscar_estudios_por_orden.php',
                        type: 'POST',
                        data: { idOrdenEstudio: idOrdenEstudio },
                        dataType: 'json',
                        success: function(data) {
                            // Limpia la tabla de estudios

                            // Agrega las filas de estudios obtenidos a la tabla
                            $.each(data, function(index, estudio) {
                                agregarFilaEstudioDesdeOrden(estudio);
                                console.log("Estudio: ", estudio.nombre_estudio);
                                console.log("Costo: ", estudio.precio);
                                console.log("corresponde a orden: ", idOrdenEstudio);
                                console.log("idEstudio: ", estudio.id_estudio);
                            });

                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                }

                // Función para agregar una fila de estudio a la tabla desde los datos obtenidos de la orden
                function agregarFilaEstudioDesdeOrden(estudio) {
                    // Agrega una nueva fila a la tabla
                    var fila = '<tr id="fila' + contadorLineas + '">' +
                        '<td>' +
                        '<input type="text" class="form-control" value="' + estudio.nombre_estudio + '" >' +
                        '<input type="hidden" name="idestudioMedico" id="idestudioMedico' + contadorLineas + '" value="' + estudio.id_estudio + '">' +
                        '</td>' +
                        '<td>' +
                        '<input type="hidden" class="form-control" id="costoEstudioOriginal' + contadorLineas + '" name="costoEstudioOriginal' + contadorLineas + '" value="' + estudio.precio + '" readonly>' +
                        '<input style="text-align:right;" type="number" class="form-control" id="costoEstudio' + contadorLineas + '" name="costoEstudio' + contadorLineas + '" value="' + parseFloat(estudio.precio).toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }) + '" readonly>' +
                        '</td>' +
                        '<td>' +
                        '<button class="btn btn-danger btnEliminarLinea" data-id="' + contadorLineas + '"><i class="fas fa-trash"></i></button>' +
                        '</td>' +
                        '</tr>';

                    // Agrega la fila a la tabla
                    $('#tablaLineasFactura tbody').append(fila);

                    // Incrementa el contador de líneas
                    contadorLineas++;

                    // Calcula el total de la factura
                    calcularTotalFactura();
                }


                // Función para calcular el total de la factura
                    function calcularTotalFactura() {
                        var totalFactura = 0;
                        // Recorre todas las filas de la tabla
                        $('#tablaLineasFactura tbody tr').each(function () {
                            // Obtiene el costo de la línea y lo suma al total
                            var costoEstudio = parseFloat($(this).find('[id^=costoEstudio]').val().replace(',', '')) || 0;
                            totalFactura += costoEstudio;
                        });
                        // Actualiza el valor del campo totalFactura
                        $('#totalFacturaOriginal').val(totalFactura);
                        $('#totalFactura').val(totalFactura.toLocaleString('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }));
                    }

                // Evento al hacer clic en el botón Guardar Factura
                $('#btnGuardarFactura').on('click', function () {
                    // Obtener los datos del formulario
                    var idCliente = $('#idPaciente').val();
                    var fechaFactura = $('#fechaFactura').val();
                    var timbradoFactura = $('#timbradoFactura').val();
                    var numeroFactura = $('#numeroFactura').val();
                    var totalFactura = $('#totalFacturaOriginal').val();
                    var condicionFactura = $('#condicionFactura').val();
                    var cuotas = $('#cuotas').val();

                    // Realizar la solicitud AJAX para guardar la factura
                    $.ajax({
                        url: 'guardar_factura_venta.php',
                        type: 'POST',
                        data: {
                            idUsuario: <?php echo $idUsuariosearch; ?>,
                            idCliente: idCliente,
                            fechaFactura: fechaFactura,
                            timbradoFactura: timbradoFactura,
                            numeroFactura: numeroFactura,
                            totalFactura: totalFactura,
                            condicionFactura: condicionFactura,
                            cuotas: cuotas,
                        },
                        success: function (data) {
                            // Console log para verificar la respuesta del servidor
                            console.log("Respuesta del servidor (guardar_factura_venta.php):", data);

                            // obtener el id de la factura recién insertada
                            var idFactura = data.idFactura;
                            console.log("Factura creada: ", idFactura);

                            // Función para enviar detalles de factura a guardar_detalle_factura_venta.php
                            guardarDetallesFactura(idFactura);

                            // agregar una pausa para que se guarden los detalles de la factura
                            setTimeout(function () {
                                // Otras acciones después de guardar la factura
                                alert('Factura guardada correctamente.');
                                // redirigir a la pagina de facturas de ventas
                                window.location.href = 'facturas_ventas.php';
                            }, 1000);
                        },
                        dataType: 'json',
                    });

                    // ... (resto del código)
                });

                // Función para guardar los detalles de la factura
                function guardarDetallesFactura(idFactura) {
                    // Recorrer cada fila de la tabla
                    $('#tablaLineasFactura tbody tr').each(function () {
                        // Obtener el número de fila
                        var idFila = $(this).attr('id').replace('fila', '');

                        // Construir los identificadores de manera más clara
                        var idEstudioMedico = $('#idestudioMedico' + idFila).val();
                        var costoEstudioOriginal = $('#costoEstudioOriginal' + idFila).val();

                        // Realizar la solicitud AJAX para guardar el detalle de la factura
                        $.ajax({
                            url: 'guardar_detalle_factura_venta.php',
                            type: 'POST',
                            data: {
                                idFactura: idFactura,
                                idEstudioMedico: idEstudioMedico,
                                observacion: '',
                                importeTotal: costoEstudioOriginal,
                            },
                            success: function (data) {
                                console.log(data);
                            },
                            error: function (error) {
                                console.log(error);
                            }
                        });
                    });
                }
                
        });
    </script>
